# Copyright (c) 2012 Barbara Schmid.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the GNU Public License v3.0
# which accompanies this distribution, and is available at
# http://www.gnu.org/licenses/gpl.html
# 
# Contributors:
#     Barbara Schmid - initial API and implementation
 
from pyramid.config import Configurator
from sqlalchemy import engine_from_config

from .models import DBSession

def main(global_config, **settings):
    """ This function returns a Pyramid WSGI application.
    """
    engine = engine_from_config(settings, 'sqlalchemy.')
    DBSession.configure(bind=engine)
    config = Configurator(settings=settings)
    config.add_static_view('static', 'static', cache_max_age=3600)
    config.add_route('home', '/')
    config.add_route('questionnaires', '/questionnaires/{timestamp}')
    config.add_route('answers', '/answers')
    config.add_route('logs', '/logs')
    config.add_route('database', '/database')
    
    # EVALUATION
    config.add_route('users', '/users')
    config.add_route('evaluation', '/evaluation/{userId}')
    config.add_route('timeline', '/timeline/{userId}')

    # APP CREATOR
    config.add_route('createapp', '/createapp')

    config.scan()
    return config.make_wsgi_app()

