# Copyright (c) 2012 Barbara Schmid.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the GNU Public License v3.0
# which accompanies this distribution, and is available at
# http://www.gnu.org/licenses/gpl.html
# 
# Contributors:
#     Barbara Schmid - initial API and implementation

from sqlalchemy import (
    Column,
    Integer,
    Text,
    Unicode,
    )

from sqlalchemy.ext.declarative import declarative_base

from sqlalchemy.orm import (
    scoped_session,
    sessionmaker,
    )

from zope.sqlalchemy import ZopeTransactionExtension

DBSession = scoped_session(sessionmaker(extension=ZopeTransactionExtension()))
Base = declarative_base()

class MyModel(Base):
    __tablename__ = 'models'
    id = Column(Integer, primary_key=True)
    name = Column(Text, unique=True)
    value = Column(Integer)

    def __init__(self, name, value):
        self.name = name
        self.value = value

class AnsweredQuestionnaire(Base):
    __tablename__ = 'answeredQuestionnaires'
    id = Column(Integer, primary_key=True)
    userId = Column(Unicode)
    timestamp = Column(Integer)
    questionnaire = Column(Unicode)
    answers = Column(Unicode)

    def __init__(self, userId, timestamp, questionnaire, answers):
        self.userId = userId
        self.timestamp = timestamp
        self.questionnaire = questionnaire
        self.answers = answers

class Log(Base):
    __tablename__ = 'logs'
    id = Column(Integer, primary_key=True)
    userId = Column(Unicode)
    timestamp = Column(Integer)
    duration = Column(Integer)
    activity = Column(Unicode)
    packagename = Column(Unicode)
    topackagename = Column(Unicode)
    location = Column(Unicode)

    def __init__(self, userId, timestamp, duration, activity, packagename, topackagename, location):
        self.userId = userId
        self.timestamp = timestamp
        self.duration = duration
        self.activity = activity
        self.packagename = packagename
        self.topackagename = topackagename
        self.location = location


