/*******************************************************************************
 * Copyright (c) 2012 Barbara Schmid.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Barbara Schmid - initial API and implementation
 ******************************************************************************/
 
var App = Em.Application.create({});

//
// Controller
//
App.Controller = Em.Object.extend({
    download: function() {
    	$.ajax({
    		url: '/database',
    		success: function(data) {
    			data.answers.forEach(function(item, index, enumerable) {
    				q = App.Answer.create(item);
    				App.answers.addObject(q);
    			});
    			data.logs.forEach(function(item, index, enumerable) {
    				q = App.Log.create(item);
    				App.logs.addObject(q);
    			});
				setTimeout('t1 = $("#answersTable"); t1.dataTable({"bPaginate":false});', 3000);
				setTimeout('t2 = $("#logsTable"); t2.dataTable({"bPaginate":false});', 3000);
    		}
    	});
    },
}).create();

//
// The Model
//

//
// Answer prototype
//
App.Answer = Em.Object.extend({
    userid: "",
    timestamp: 0,
	questionnaire: "",
    answers: "",
});

//
// Log prototype
//
App.Log = Em.Object.extend({
    userid: "",
    timestamp: 0,
	duration: 0,
    activity: "",
    packagename: "",
    topackagename: "",
    location: "",
});

App.answers = Em.ArrayController.create({content:[]});
App.logs = Em.ArrayController.create({content:[]});
App.Controller.download();

