/*******************************************************************************
 * Copyright (c) 2012 Barbara Schmid.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Barbara Schmid - initial API and implementation
 ******************************************************************************/
 
var App = Em.Application.create({});

//
// Controller
//
App.Controller = Em.Object.extend({
    downloadEvaluation: function() {
    	$.ajax({
    		url: '/evaluation/1',
    		success: function(data) {
			App.v = data
			//
			// SystemInfo
			//
    			data.evaluation.systeminfo.forEach(function(item, index, enumerable) {
	    			q = App.Sysinfo.create(item);
				answers = JSON.parse(q.answers)
				q.mode = answers.mode;
				q.model = answers.model;
				q.device = answers.device;
				q.version = answers.version;
				q.apiLevel = answers.apiLevel;
				q.screen = answers.screen;
				q.camera = answers.camera;
				q.nfc = answers.nfc;
    				App.sysinfo.addObject(q);
    			});
			
			//
			// Anfangs Fragebogen
			//
			aqizer = function(item) {
	    			q = App.Aq.create(item);
				answers = JSON.parse(q.answers)
				q.sex = answers[0];
				q.age = parseInt(answers[1]);
				q.occupation = answers[2];
				q.degree = answers[3];
				q.agephone = answers[4];
				q.agefbapp = answers[5];
				q.durationfb = answers[6];
				q.unknownfb = answers[7];
				q.durationem = answers[8];
				q.unknownem = answers[9];
				q.whatyoudo = answers[10];
				q.appsperweek = parseInt(answers[11]);
				q.networkconnection = answers[12];
				q.username = answers[13];
				
				multipart = JSON.parse(q.whatyoudo)
				q.appCalender = multipart.indexOf("Kalender") >= 0
				q.appMusic = multipart.indexOf("Musik") >= 0
				q.appGames = multipart.indexOf("Spiele") >= 0
				q.appMaps = multipart.indexOf("Maps / Routenplaner") >= 0
				q.appWeather = multipart.indexOf("Wetter") >= 0
				q.appYoutube = multipart.indexOf("YouTube") >= 0
				q.appOther = multipart.indexOf("sonstige") >= 0

				return q;
			}

			aqstatincrement = function(stat, q) {
				stat.set('sex', stat.sex + (q.sex=="weiblich")?1:0);
				stat.set('age', stat.age + q.age);
			}

			aqstatnorm = function(stat, num) {
				stat.set('sex', stat.sex / num);
				stat.set('age', stat.age / num);
			}
			
			data.evaluation.aq.EVENTTRIGGERED.forEach(function(item, index, enumerable) {
				q = aqizer(item);
    				App.aq.eventtriggered.addObject(q);

				aqstatincrement(App.aq.eventtriggered_stats, q);
				aqstatincrement(App.aq.overall_stats, q);
    			});
			aqstatnorm(App.aq.eventtriggered_stats, data.evaluation.aq.EVENTTRIGGERED.length);

    			data.evaluation.aq.INTERVALTRIGGERED.forEach(function(item, index, enumerable) {
				q = aqizer(item);
    				App.aq.intervaltriggered.addObject(q);

				aqstatincrement(App.aq.intervaltriggered_stats, q);
				aqstatincrement(App.aq.overall_stats, q);
    			});
			aqstatnorm(App.aq.intervaltriggered_stats, data.evaluation.aq.INTERVALTRIGGERED.length);

    			data.evaluation.aq.VOLUNTARY.forEach(function(item, index, enumerable) {
				q = aqizer(item);
    				App.aq.voluntary.addObject(q);

				aqstatincrement(App.aq.voluntary_stats, q);
				aqstatincrement(App.aq.overall_stats, q);
    			});
			aqstatnorm(App.aq.voluntary_stats, data.evaluation.aq.VOLUNTARY.length);
			
			aqstatnorm(App.aq.overall_stats,
				data.evaluation.aq.EVENTTRIGGERED.length + 
				data.evaluation.aq.INTERVALTRIGGERED.length + 
				data.evaluation.aq.VOLUNTARY.length);
			
			
			//
			// End Fragebogen
			//
			eqizer = function(item) {
	    			q = App.Eq.create(item);
				answers = JSON.parse(q.answers)
				
				q.effortfb = App.scale.indexOf(answers[0]);
				q.performancefb = App.scale.indexOf(answers[1]);
				q.effortem = App.scale.indexOf(answers[2]);
				q.performanceem = App.scale.indexOf(answers[3]);
				q.performanceweek = answers[4];
				q.uiisnice = App.scale.indexOf(answers[5]);
				q.uiisintuitive = App.scale.indexOf(answers[6]);
				q.batteryisok = App.scale.indexOf(answers[7]);
				q.questmode = answers[8];
				q.usagefb = App.scale.indexOf(answers[9]);
				q.usageem = App.scale.indexOf(answers[10]);
				q.usagehow = answers[11];
				q.feedback = answers[12];
				return q;
			}

			eqstatincrement = function(stat, q) {
				stat.set('effortfb', stat.effortfb + q.effortfb);
				stat.set('performancefb', stat.performancefb + q.performancefb);
				stat.set('effortem', stat.effortem + q.effortem);
				stat.set('performanceem', stat.performanceem + q.performanceem);
				stat.set('uiisnice', stat.uiisnice + q.uiisnice);
				stat.set('uiisintuitive', stat.uiisintuitive + q.uiisintuitive);
				stat.set('batteryisok', stat.batteryisok + q.batteryisok);
				stat.set('usagefb', stat.usagefb + q.usagefb);
				stat.set('usageem', stat.usageem + q.usageem);
			}

			eqstatnorm = function(stat, num) {
				stat.set('effortfb', stat.effortfb / num);
				stat.set('performancefb', stat.performancefb / num);
				stat.set('effortem', stat.effortem / num);
				stat.set('performanceem', stat.performanceem / num);
				stat.set('uiisnice', stat.uiisnice / num);
				stat.set('uiisintuitive', stat.uiisintuitive / num);
				stat.set('batteryisok', stat.batteryisok / num);
				stat.set('usagefb', stat.usagefb / num);
				stat.set('usageem', stat.usageem / num);
			}
			
			data.evaluation.eq.EVENTTRIGGERED.forEach(function(item, index, enumerable) {
				q = eqizer(item);
    				App.eq.eventtriggered.addObject(q);

				eqstatincrement(App.eq.eventtriggered_stats, q);
				eqstatincrement(App.eq.overall_stats, q);
    			});
			eqstatnorm(App.eq.eventtriggered_stats, data.evaluation.eq.EVENTTRIGGERED.length);

    			data.evaluation.eq.INTERVALTRIGGERED.forEach(function(item, index, enumerable) {
				q = eqizer(item);
    				App.eq.intervaltriggered.addObject(q);

				eqstatincrement(App.eq.intervaltriggered_stats, q);
				eqstatincrement(App.eq.overall_stats, q);
    			});
			eqstatnorm(App.eq.intervaltriggered_stats, data.evaluation.eq.INTERVALTRIGGERED.length);

    			data.evaluation.eq.VOLUNTARY.forEach(function(item, index, enumerable) {
				q = eqizer(item);
    				App.eq.voluntary.addObject(q);

				eqstatincrement(App.eq.voluntary_stats, q);
				eqstatincrement(App.eq.overall_stats, q);
    			});
			eqstatnorm(App.eq.voluntary_stats, data.evaluation.eq.VOLUNTARY.length);
			
			eqstatnorm(App.eq.overall_stats,
				data.evaluation.eq.EVENTTRIGGERED.length + 
				data.evaluation.eq.INTERVALTRIGGERED.length + 
				data.evaluation.eq.VOLUNTARY.length);
    		}
    	});
    },
    downloadUsers: function() {
    	$.ajax({
    		url: '/users',
    		success: function(data) {
    			data.users.forEach(function(item, index, enumerable) {
	    			q = App.User.create(item);
    				App.users.addObject(q);
    			});
    		}
    	});
    },
    downloadTimeline: function(but) {
    	userId = but.bindingContext.content.userId

    	App.set("timeline",    Em.ArrayController.create({content:[]}));

    	$.ajax({
    		url: '/timeline/' + userId,
    		success: function(data) {
    			data.timeline.forEach(function(item, index, enumerable) {
				if (item.duration) {
					item.duration = Math.round(item.duration / 1000);
				}
				item.className = item.packagename.replace(/\./g,'_')
				q = App.Timeline.create(item);
				if (q.answers) {				
					answers = JSON.parse(q.answers);
					q.answer1 = answers[0];
					q.answer2 = answers[1];
					q.answer3 = answers[2];
					q.answer4 = answers[3];
				}
				if (q.questionnaire) {
					q.islog = 0
					q.isapp = 1
					q.autoopen = 0
				} else {
					q.islog = 1
					q.isapp = 0

					q.autoopen = 0
					if (index+1 < data.timeline.length) {
						if (data.timeline[index+1].activity == "com.questionnaire.QuestionnaireActivity") {
							q.autoopen = 1
						}
					}
					
				}
				App.timeline.addObject(q);

				if (q.questionnaire == "Facebook - Fragebogen" || q.packagename == "com.facebook.katana") {
					App.timeline_fb.addObject(q);
				}
				emailapplist = [ 
					"com.google.android.gm",
					"com.android.email",
					"de.gmx.mobile.android.mail",
					"com.htc.android.mail",
					"com.fsck.k9",
					"com.motorola.blur.email",
					"com.google.android.email",
					"com.yahoo.mobile.client.android.mail",
					"de.web.mobile.android.mail"
				];

				if (q.questionnaire == "Mail - Fragebogen" || emailapplist.indexOf(q.packagename) >= 0) {
					App.timeline_em.addObject(q);
				}




    			});
    		}
    	});
    },
}).create();

//
// The Model
//

//
// User prototype
//
App.User = Em.Object.extend({
    userid: "",
});
App.users = Em.ArrayController.create({content:[]});

//
// Sysinfo prototype
//
App.Sysinfo = Em.Object.extend({
    userid: "",
    timestamp: 0,
    answers: "",
    mode: "",
    model: "",
    device: "",
    version: "",
    apiLevel: "",
    screen: "",
    camera: false,
    nfc: false,
    gps: false,
});
App.sysinfo = Em.ArrayController.create({content:[]});

//
// Anfangsfragebogen prototype
//
App.Aq = Em.Object.extend({
    userid: "",
    timestamp: 0,
    answers: "",
    sex: "",
    age: "",
    occupation: "",
    degree: "",
    agephone: 0,
    agefbapp: 0,
    durationfb: "",
    unknownfb: "",
    durationem: "",
    unknownem: "",
    whatyoudo: "",
    appsperweek: 0,
    networkconnection: "",
    username: "",
    appCalender: "",
    appMusic: "",
    appGames: "",
    appMaps: "",
    appWeather: "",
    appYoutube: "",
    appOther: "",
});

//
// Anfangsfragebogen stats prototype
//
App.AqStats = Em.Object.extend({
    sex: 0,
    age: 0,
});

App.aq = {};
App.aq.eventtriggered = Em.ArrayController.create({content:[]});
App.aq.intervaltriggered = Em.ArrayController.create({content:[]});
App.aq.voluntary = Em.ArrayController.create({content:[]});
App.aq.eventtriggered_stats = App.AqStats.create();
App.aq.intervaltriggered_stats = App.AqStats.create();
App.aq.voluntary_stats = App.AqStats.create();
App.aq.overall_stats = App.AqStats.create();

//
// Endfragebogen prototype
//
App.Eq = Em.Object.extend({
    userid: "",
    timestamp: 0,
    answers: "",
    effortfb: 0,
    performancefb: 0,
    effortem: 0,
    performanceem: 0,
	performanceweek: "",
    uiisnice: 0,
    uiisintuitive: 0,
    batteryisok: 0,
	questmode: "",
	usagefb: 0,
	usageem: 0,
	usagehow: "",
    feedback: "",
});

//
// Endfragebogen stats prototype
//
App.EqStats = Em.Object.extend({
    effortfb: 0,
    performancefb: 0,
    effortem: 0,
    performanceem: 0,
    uiisnice: 0,
    uiisintuitive: 0,
    batteryisok: 0,
	usagefb: 0,
	usageem: 0,
});

App.eq = {};
App.eq.eventtriggered = Em.ArrayController.create({content:[]});
App.eq.intervaltriggered = Em.ArrayController.create({content:[]});
App.eq.voluntary = Em.ArrayController.create({content:[]});
App.eq.eventtriggered_stats = App.EqStats.create();
App.eq.intervaltriggered_stats = App.EqStats.create();
App.eq.voluntary_stats = App.EqStats.create();
App.eq.overall_stats = App.EqStats.create();

App.scale = [ "", "Stimme überhaupt nicht zu.", "Stimme teilweise nicht zu.", "Unentschieden.", "Stimme teilweise zu.", "Stimme voll zu." ];

//
// Timeline prototype
//
App.Timeline = Em.Object.extend({
    timestamp: 0,
    questionnaire: "",
    answers: "",
    duration: 0,
    activity: "",
    packagename: "",
    topackagename: "",
    location: "",
    className: "",
    answer1: "",
    answer2: "",
    answer3: "",
    answer4: "",
    islog: 0,
    isanswer: 0,
	autoopen: 0,
});
App.timeline = Em.ArrayController.create({content:[]});
App.timeline_fb = Em.ArrayController.create({content:[]});
App.timeline_em = Em.ArrayController.create({content:[]});
//setTimeout('t1 = $("#answersTable"); t1.dataTable({"bPaginate":false});', 1000);
//setTimeout('t2 = $("#logsTable"); t2.dataTable({"bPaginate":false});', 1000);


App.Controller.downloadEvaluation();
App.Controller.downloadUsers();

