/*******************************************************************************
 * Copyright (c) 2012 Barbara Schmid.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Barbara Schmid - initial API and implementation
 ******************************************************************************/
 
var App = Em.Application.create({});



//
// DatePicker with time of day view
//
App.MyDatePicker = Em.TextField.extend({
    didInsertElement: function() {
        var view = this;
        view.$().datetimepicker({
			dateFormat: "yy-mm-dd",
	});
    },
});



//
// Sortable collection view
//
$.fn.extend({
  safeClone: function() {
    var clone;
    clone = $(this).clone();
    clone.find('script[id^=metamorph]').remove();
    clone.removeClass('Em-view');
    clone.find('*').each(function() {
      var $this;
      $this = $(this);
      $this.removeClass('Em-view');
      return $.each($this[0].attributes, function(index, attr) {
        if (attr.name.indexOf('data-bindattr') === -1) {
          return;
        }
        return $this.removeAttr(attr.name);
      });
    });
    if (clone.attr('id')) if (clone.attr('id').indexOf('Em') !== -1) {
      clone.removeAttr('id');
    }
    
    clone.find('[id^=Em]').removeAttr('id');
    return clone;
  }
});

App.MySortableView = Em.CollectionView.extend({
    tagName: "ul",
    moveItem: function(fromIndex, toIndex){
        var items = this.get('content');
        item = items.objectAt(fromIndex);
        items.removeAt(fromIndex);
        items.insertAt(toIndex, item);
    },
    didInsertElement: function() {
        var view = this;
        view.$().sortable({
            start: function(event, ui) {
                ui.item.previousIndex = ui.item.index();                      
            },
            stop: function(event, ui) {
                view.moveItem(ui.item.previousIndex, ui.item.index());
            },
            helper: function(event, ui) {
                return $(ui).safeClone();            
            },
        })
    },
});

//
// Handlebars "if helper"
//
Handlebars.registerHelper('iftype', function(item, block) {
  if(item == this.content.type) {
    return block(this);
  }
});



//
// Controller
//
App.Controller = Em.Object.extend({
    delChoice: function(v) {
        choices = v.get("collectionView").content;
        choices.removeObject(v.bindingContext.content);
    },
    newChoice: function(v) {
        v.choices.addObject(Em.Object.create({text: "Please enter"}));
    },
    delQuestion: function(v) {
        App.q.questions.removeObject(v.content);
    },
    addQuestion: function(v) {
		hash = { type: v.type };

		switch(v.type) {
			case "radio":
			case "check":
			case "likert":
			case "dropdown":
				hash.choices = [ Em.Object.create({text: 'Please enter answer here'}), Em.Object.create({text: 'or add a new one'}) ];
				break;
			case "text":
				break;
			case "edittext":
				hash.prompt = 'This prompt will be shown to the participants.';
				hash.numlines = 1;
				break;
			case "scaleedit":
				hash.value = 3;
				hash.maxValue = 100;
				hash.unit = "dBm";
				break;
			default:
				alert("Unknown questiontype, code is buggy");
		}

    	App.q.questions.addObject(App.Question.create(hash));
    },
    editQuestionnaire: function(v) {
    	App.set("q", v.bindingContext.content);
    },
    delQuestionnaire: function(v) {
		if (App.q == v.bindingContext.content) App.Controller.closeEditor();
        App.qs.removeObject(v.bindingContext.content);
    },
    addQuestionnaire: function() {
        q = App.Questionnaire.create({
            questions: Em.ArrayController.create({content:[]}),
        });
	App.qs.addObject(q);
	App.set("q", q);
    },
    closeEditor: function() {
		App.set("q", null);
    },
    uploadQs: function() {
    	data = {};
    	App.qs.forEach(function(item, index, enumerable){
			data[item.title] = item.toXML();
		});
		while(App.qs.get("length")) App.qs.removeAt(0);
		App.set("q", null);
    	$.ajax({
			type: 'POST',
    		url: '/questionnaires/0',
			data: JSON.stringify(data),
			dataType: "json",
    		success: function(data) {
				App.Controller.downloadQs();
    		}
    	});
    },
    downloadQs: function() {
    	$.ajax({
    		url: '/questionnaires/0',
    		success: function(data) {
    			data.questionnaires.forEach(function(item, index, enumerable) {
    				q = App.Questionnaire.create({
    					questions: Em.ArrayController.create({content:[]}),
    				});
    				q.fromXML(item);
    				App.qs.addObject(q);
    			});
    		}
    	});
    },
}).create();


//
// Helper to embed value in tags: <tag>value</tag>
//
tag = function(tag, value) {
	if (value !== undefined) {
		// indent all lines of value by one tabstop
		value = String(value).split("\n").map(function(i) {
			return "\t"+i;
		}).join("\n");
		return "<" + tag + ">\n" + value + "\n</" + tag + ">\n";
	} else {
		// do not output tags with empty elements
		return "";
	}
}






//
// The Model
//



//
// Questionnaire prototype
//
App.Questionnaire = Em.Object.extend({
    title: "Name of the questionnaire",
    startdate: 0,
	description: "",
    repeattime: 0,
	repeatnumber: 0,
	autoopen: 0,
	groupids: 1,
	enddate: 0,
	logactivity: "com.questionnaire.chooser, com.android.mms.contacts",
	logpackage: "com.questionnaire, com.android.mms",
    questions: null,
    
    toXML: function() {
    	questions = "";
        this.questions.forEach(function(item, index, enumerable){
            questions += item.toXML();
        });

    	result = tag("questionnaire", 
			tag("title", this.title) +
			tag("description", this.description) +			
			tag("startdate", this.startdate) + 
			tag("repeattime", this.repeattime) +
			tag("repeatnumber", this.repeatnumber) +			
			tag("autoopen", this.autoopen) +			
			tag("groupids", this.groupids) +			
			tag("enddate", this.enddate) +
			tag("logactivity", this.logactivity) +
			tag("logpackage", this.logpackage) +			
			tag("questions", questions)
		);

		return result;
    },
    fromXML: function(xml) {
    	xml = $.parseXML(xml)
		quest = xml.getElementsByTagName("questionnaire")[0];
		for (var i=0; i<quest.childNodes.length; i++) {
			if (quest.childNodes[i].nodeName == "#text") {
			// do nothing
			} else if (quest.childNodes[i].nodeName == "questions") {
				questi = quest.childNodes[i];
				for (var j=0; j<questi.childNodes.length; j++) {
					if (questi.childNodes[j].nodeName != "#text") {
						question = App.Question.create();
						question.fromXML(questi.childNodes[j])
						this.questions.addObject(question);
					}
				}
			} else {
        		this.set(quest.childNodes[i].nodeName, quest.childNodes[i].textContent.trim());
			}
		}
    },
});



//
// Question prototype
//
App.Question = Em.Object.extend({
    type: null,
    question: "Please enter your question here.",
    
    toXML: function() {
		choices = "";
		if (this.choices) {
			this.choices.forEach(function(item, index, enumerable){
				choices += tag("choice", item.text);
			});
		}
        result = tag(this.type, 
			tag("question", this.question) +
			tag("prompt", this.prompt) +
			tag("numlines", this.numlines) +
			tag("value", this.value) +
			tag("maxValue", this.maxValue) +
			tag("unit", this.unit) +
			choices
		);
        return result;
    },
    fromXML: function(xml) {
		this.set("type", xml.nodeName);
		for (var i=0; i<xml.childNodes.length; i++) {
			if (xml.childNodes[i].nodeName == "#text") {
				// do nothing
			} else if (xml.childNodes[i].nodeName == "choice") {
				if (this.choices === undefined)
					this.choices = Em.ArrayController.create({content:[]});
				this.choices.addObject(Em.Object.create({text: xml.childNodes[i].textContent.trim()}));
			} else {
        		this.set(xml.childNodes[i].nodeName, xml.childNodes[i].textContent.trim());
			}
		}
    },
});


App.qs = Em.ArrayController.create({content:[]});
App.Controller.downloadQs();

